<?php
	/**********************************************
	CUSTOM FEATURED WORK WIDGET
	***********************************************/
	
	class photo_Widget_Featured_Work extends WP_Widget {
	
		function photo_Widget_Featured_Work() {		
			$widget_ops = array('classname' => 'widget-featured-work', 'description' => __('Custom widget for portfolio featured work', CODEEX_THEME_NAME));	
			$this -> WP_Widget('FeaturedWork', __('Photo: Featured Work', CODEEX_THEME_NAME), $widget_ops);		
		}
	
		function widget($args, $instance) {		
			extract($args);		
			$title = apply_filters('widget_title', $instance['title']);		
			if (empty($title)) $title = false;
				$instance_work_limit = array();
				
				$work_limit = 'work_limit';
				$instance_work_limit = isset($instance[$work_limit]) ? $instance[$work_limit] : '';
							
				echo ''.$before_widget.'';					
				if ($title) {						
					echo $before_title;
			 		echo $title;
			 		echo $after_title.'';						
			 	}

					global $post;
			 		$args = array( 'post_type' => 'portfolio', 'posts_per_page' => $instance_work_limit, 'meta_query' => array( array( 'key' => 'featured', 'value' => 'on', 'compare' => '==' ) ) );		
					$wp_query = new WP_Query( $args );						
					?>
						<ul class="clear">
							<?php
								while ($wp_query->have_posts()) : $wp_query->the_post(); 
									?>
									<li>
										<a href="<?php the_permalink(); ?>"><?php if ( has_post_thumbnail() ) { the_post_thumbnail('widget-thumb'); } ?></a>			
									</li>
									<?php
								endwhile;	
							?>
						</ul>
					<?php
					wp_reset_query();

					echo $after_widget.'';				
				}
			
				function update($new_instance, $old_instance) {				
					$instance = $old_instance;				
					$instance['title'] = strip_tags($new_instance['title']);
					$instance['work_limit'] = $new_instance['work_limit'];				
					return $instance;				
				}
			
				function form($instance) {				
					$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
					$instance_work_limit = array();							
					
					$work_limit = 'work_limit';
					$instance_work_limit = isset($instance[$work_limit]) ? $instance[$work_limit] : '';					
					
				?>
					<p><label for="<?php echo $this -> get_field_id('title'); ?>"><?php _e('Title:', CODEEX_THEME_NAME); ?></label>
					<input class="widefat" id="<?php echo $this -> get_field_id('title'); ?>" name="<?php echo $this -> get_field_name('title'); ?>" type="text" value="<?php echo $title; ?>" /></p>					
					<div>			
						<div>
							<p><label for="<?php echo $this -> get_field_id($work_limit); ?>"><?php _e('Number of Posts:', CODEEX_THEME_NAME); ?></label>
							<input class="widefat" type="text" id="<?php echo $this -> get_field_id($work_limit); ?>" name="<?php echo $this -> get_field_name($work_limit); ?>" value="<?php echo $instance_work_limit; ?>">
							</p>														
						</div>			
					</div>
		<?php
				}			
		}

		function photo_widget_featured_work() {			
			register_widget('photo_Widget_Featured_Work');			
		}
		add_action('widgets_init', 'photo_widget_featured_work');
?>