<?php
	/**********************************************
	CUSTOM POST TYPE: TESTIMONIALS
	***********************************************/
	
	add_action( 'init', 'photo_testimonial_post_type' );
	function photo_testimonial_post_type() {

		if(get_option('photo_testimonial_cpt')!="") { $testimonial_name = get_option('photo_testimonial_cpt'); } else { $testimonial_name = "Testimonials"; }
		if(get_option('photo_testimonial_cpt_slug')!="") { $testimonial_slug = get_option('photo_testimonial_cpt_slug'); } else { $testimonial_slug = "testimonial-item"; }
		if(get_option('photo_testimonial_add')!="") { $testimonial_add = get_option('photo_testimonial_add'); } else { $testimonial_add = "Add New Testimonial"; }
		if(get_option('photo_testimonial_edit')!="") { $testimonial_edit = get_option('photo_testimonial_edit'); } else { $testimonial_edit = "Edit Testimonial"; }

		register_post_type( 'testimonials',
			array(
				'labels' => array(
					'name' => $testimonial_name,
					'singular_name' => $testimonial_name,
					'add_new_item' => $testimonial_add,
					'edit_item' => $testimonial_edit,
				),
				'public' => true,
				'has_archive' => true,
				'rewrite' => array( 'slug' => $testimonial_slug, 'with_front' => TRUE ),
				'supports' => array('title','editor','author','thumbnail'),
				'menu_icon' => get_template_directory_uri() . '/includes/posts/img/testimonials.png'				
			)
		);
	}


	/*META*/
	function photo_testimonial_meta() {
		global $post;

		$position = get_post_meta($post->ID, 'position', TRUE);
		?>
			<div class="mabuc-form-wrap">	
				<table>
					<tr>
						<td style="width:10%"><label for="position"><?php _e( 'Position', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="position" type="text" id="position" value="<?php echo $position; ?>" /> <br>
							<span class="desc"><?php _e( 'Add position for the user', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>					
				</table>					
			</div>		
		<?php	
	}

	/*CUSTOM COLUMNS*/
	add_filter( 'manage_edit-testimonial_columns', 'edit_testimonial_columns' ) ;
	function edit_testimonial_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __( 'Name', CODEEX_THEME_NAME ),			
			'author' => __( 'Author', CODEEX_THEME_NAME ),
			'date' => __( 'Date', CODEEX_THEME_NAME )
		);
		return $columns;
	}

	/**********************************************
	SAVE & UPDATE CUSTOM FIELDS
	***********************************************/
	
	add_action( 'add_meta_boxes', 'photo_custom_posts_testimonial' );
	function photo_custom_posts_testimonial(){
		add_meta_box("photo_testimonial_meta", "Testimonial Options", "photo_testimonial_meta", "testimonials", "normal", "low");
	}	
	
	add_action('save_post', 'photo_custom_posts_save_testimonial');
	function photo_custom_posts_save_testimonial( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }
		
		update_post_meta($post_id, "position", @$_POST["position"]);		
	}	
?>