<?php
	/**********************************************
	CUSTOM POST TYPE: SKILLS
	***********************************************/	
	
	add_action( 'init', 'photo_skills_post_type' );
	function photo_skills_post_type() {

		if(get_option('photo_skills_cpt')!="") { $skills_name = get_option('photo_skills_cpt'); } else { $skills_name = "Skills"; }
		if(get_option('photo_skills_cpt_slug')!="") { $skills_slug = get_option('photo_skills_cpt_slug'); } else { $skills_slug = "skills"; }
		if(get_option('photo_skills_add')!="") { $skills_add = get_option('photo_skills_add'); } else { $skills_add = "Add New Skills"; }
		if(get_option('photo_skills_edit')!="") { $skills_edit = get_option('photo_skills_edit'); } else { $skills_edit = "Edit Skills"; }

		register_post_type( 'skills',
			array(
				'labels' => array(
					'name' => __( $skills_name, 'photo_lang' ),
					'singular_name' => __( $skills_name, 'photo_lang' ),
					'add_new_item' => __( $skills_add, 'photo_lang' ),
					'edit_item' => __( $skills_edit, 'photo_lang' ),
				),
				'public' => true,
				'has_archive' => true,				
				'rewrite' => array('slug' => $skills_slug, 'with_front' => TRUE),
				'supports' => array('title','author', 'page-attributes'),
				'menu_icon' => get_template_directory_uri() . '/includes/posts/img/skills.png'			
			)
		);
	}	
	
	/*META*/
	function photo_skills_meta() {
		global $post;

		$percent = get_post_meta($post->ID, 'percent', TRUE);
		?>
			<div class="mabuc-form-wrap">
				<table>
					<tr>
						<td style="width:10%;"><label for="percent"><?php _e( 'Percent', 'photo_lang' ); ?></label></td>
						<td>
							<input id="percent" name="percent" type="text" value="<?php echo $percent; ?>" /><br>
							<span class="desc"><?php _e( 'How many percentage do you have in this skill (max: 100%)', 'photo_lang' ); ?></span>
						</td>
					</tr>
				</table>
			</div>	
		<?php
	}
	
	/*CUSTOM COLUMNS*/
	add_filter( 'manage_edit-skills_columns', 'photo_edit_skills_columns' ) ;
	function photo_edit_skills_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __( 'Name', 'photo_lang' ),			
			'percent' => __( 'Percentage', 'photo_lang' ),
			'author' => __( 'Author', 'photo_lang' ),
			'date' => __( 'Date', 'photo_lang' )
		);
		return $columns;
	}
	
	/*CUSTOM COLUMNS LIST*/
	add_action( 'manage_skills_posts_custom_column', 'photo_manage_skills_columns', 10, 2 );
	function photo_manage_skills_columns( $column, $post_id ) {
		global $post;

		switch( $column ) {
			case 'percent' :
				$percent = get_post_meta( $post_id, 'percent', true );
				if ( empty( $percent ) )
					echo __( 'Unknown', 'photo_lang' );
				else
					printf( __( '%s', 'photo_lang' ), $percent );
			break;

			
			default :
			break;
		}
	}	


	/**********************************************
	SAVE & UPDATE CUSTOM FIELDS
	***********************************************/
	
	add_action( 'add_meta_boxes', 'photo_custom_posts_skills' );
	function photo_custom_posts_skills(){
		add_meta_box("photo_skills_meta", "Skills Options", "photo_skills_meta", "skills", "normal", "low");	
	}	
	
	add_action('save_post', 'photo_custom_posts_save_skills');
	function photo_custom_posts_save_skills( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }
		
		update_post_meta($post_id, "percent", @$_POST["percent"]);
	}	
?>