<?php
	/**********************************************
	CUSTOM POST TYPE: PORTFOLIO
	***********************************************/	

	add_action( 'init', 'photo_portfolio_post_type' );
	function photo_portfolio_post_type() { 

		if(get_option('photo_portfolio_cpt')!="") { $portfolio_name = get_option('photo_portfolio_cpt'); } else { $portfolio_name = "Portfolio"; }
		if(get_option('photo_portfolio_cpt_slug')!="") { $portfolio_slug = get_option('photo_portfolio_cpt_slug'); } else { $portfolio_slug = "portfolio-item"; }
		if(get_option('photo_portfolio_add')!="") { $portfolio_add = get_option('photo_portfolio_add'); } else { $portfolio_add = "Add Portfolio"; }
		if(get_option('photo_portfolio_edit')!="") { $portfolio_edit = get_option('photo_portfolio_edit'); } else { $portfolio_edit = "Edit Portfolio"; }
		
		register_post_type( 'portfolio',
			array(
				'labels' => array(
					'name' => $portfolio_name,
					'singular_name' => $portfolio_name,
					'add_new_item' => $portfolio_add,
					'edit_item' => $portfolio_edit,
				),
				'public' => true,
				'has_archive' => true,	
				'publicly_queryable' => true,
				'show_ui' => true, 
			    'show_in_menu' => true, 
			    'query_var' => true,	
			    'rewrite' => array( 'slug' => $portfolio_slug, 'with_front' => TRUE ),
			    'supports' => array('title', 'editor', 'author', 'thumbnail', 'page-attributes'),
				'menu_icon' => get_template_directory_uri() . '/includes/posts/img/portfolio.png'		
			)
		);
	}
	
	/*META*/
	function photo_portfolio_meta() {
		global $post;

		$featured = get_post_meta($post->ID, 'featured', TRUE);
		$url = get_post_meta($post->ID, 'url', TRUE);
		$subtitle = get_post_meta($post->ID, 'subtitle', TRUE);
		$bgimage = get_post_meta($post->ID, 'bgimage', TRUE);
		$video = get_post_meta($post->ID, 'video', TRUE);

		?>
			<div class="mabuc-form-wrap">	
				<table>
					<tr>
						<td style="width:10%"><label for="featured"><?php _e( 'Featured', CODEEX_THEME_NAME ); ?></label> </td>
						<td>
							<input name="featured" type="checkbox" id="featured" <?php if( $featured == true ) { ?>checked="checked"<?php } ?> />
							<span class="desc"><?php _e( 'Check this if you want to feature this portfolio', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="subtitle"><?php _e( 'Subtitle', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="subtitle" type="text" id="subtitle" value="<?php echo $subtitle; ?>" /> <br>
							<span class="desc"><?php _e( 'Add your portfolio subtitle for slider', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="url"><?php _e( 'Website', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="url" type="text" id="url" value="<?php echo $url; ?>" /> <br>
							<span class="desc"><?php _e( 'Add your portfolio website or link here', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="video"><?php _e( 'Video', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="video" type="text" id="video" value="<?php echo $video; ?>" /><br>
							<span class="desc"><?php _e( 'Add your video embedded code here (ex: http://player.vimeo.com/video/21942776 and http://www.youtube.com/v/f2XQ97XHjVw)', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="bgimage"><?php _e( 'Background', CODEEX_THEME_NAME ); ?></label></td>
						<td>	
							<input name="bgimage" type="text" id="bgimage" value="<?php echo $bgimage; ?>" /> <input id="upload_image_button_photo_bgimage" type="button" value="Upload" class="button-secondary" /><br>
							<span class="desc"><?php _e( 'Add your header image here', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
				</table>					
			</div>		
		<?php	
	}

	
	/*TAXONOMIES*/
	add_action( 'init', 'photo_portfolio_taxonomies', 0 );
	function photo_portfolio_taxonomies() {
		if(get_option('photo_portfolio_tax_slug')!="") { $portfolio_tax_slug = get_option('photo_portfolio_tax_slug'); } else { $portfolio_tax_slug = "portfolio-category"; }

		register_taxonomy( 'portfolio_categories', 'portfolio', array( 'hierarchical' => true, 'label' => 'Categories', 'query_var' => true, 'rewrite' => array('slug' => $portfolio_tax_slug) ) );
	}

	/*CUSTOM COLUMNS*/
	add_filter( 'manage_edit-portfolio_columns', 'photo_edit_portfolio_columns' ) ;
	function photo_edit_portfolio_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __( 'Name', CODEEX_THEME_NAME ),						
			'category' => __( 'Categories', CODEEX_THEME_NAME ),
			'author' => __( 'Author', CODEEX_THEME_NAME ),
			'thumbnail' => __( 'Thumbnail', CODEEX_THEME_NAME ),
			'date' => __( 'Date', CODEEX_THEME_NAME )
		);
		return $columns;
	}

	/*CUSTOM COLUMNS LIST*/
	add_action( 'manage_portfolio_posts_custom_column', 'photo_manage_portfolio_columns', 10, 2 );
	function photo_manage_portfolio_columns( $column, $post_id ) {
		global $post;

		switch($column) {
			case 'category' :
				$terms = get_the_terms( $post_id, 'portfolio_categories' );
				if ( !empty( $terms ) ) {
					$out = array();
					foreach ( $terms as $term ) {
						$out[] = sprintf( '<a href="%s">%s</a>',
							esc_url( add_query_arg( array( 'post_type' => $post->post_type, 'portfolio_categories' => $term->slug ), 'edit.php' ) ),
							esc_html( sanitize_term_field( 'name', $term->name, $term->term_id, 'portfolio_categories', 'display' ) )
						);
					}
					echo join( ', ', $out );
				}				
				else { __( 'No Categories', CODEEX_THEME_NAME ); }
			break;

			case 'thumbnail' : 
      			echo the_post_thumbnail( array(35,35) );
      		break;
			
			default :
			break;
		}
	}


	/**********************************************
	SAVE & UPDATE CUSTOM FIELDS
	***********************************************/
	
	add_action( 'add_meta_boxes', 'photo_custom_posts_portfolio' );
	function photo_custom_posts_portfolio(){
		add_meta_box("photo_portfolio_meta", "Portfolio Options", "photo_portfolio_meta", "portfolio", "normal", "low");
	}	
	
	add_action('save_post', 'photo_custom_posts_save_portfolio');
	function photo_custom_posts_save_portfolio( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }
		
		update_post_meta($post_id, "featured", @$_POST["featured"]);
		update_post_meta($post_id, "subtitle", @$_POST["subtitle"]);
		update_post_meta($post_id, "url", @$_POST["url"]);
		update_post_meta($post_id, "video", @$_POST["video"]);
		update_post_meta($post_id, "bgimage", @$_POST["bgimage"]);
	}	
?>