<?php
	/**********************************************
	CUSTOM POST TYPE: OUR TEAM
	***********************************************/	
	
	add_action( 'init', 'photo_team_post_type' );
	function photo_team_post_type() {

		if(get_option('photo_team_cpt')!="") { $team_name = get_option('photo_team_cpt'); } else { $team_name = "Our Team"; }
		if(get_option('photo_team_cpt_slug')!="") { $team_slug = get_option('photo_team_cpt_slug'); } else { $team_slug = "ourteam"; }
		if(get_option('photo_team_add')!="") { $team_add = get_option('photo_team_add'); } else { $team_add = "Add New Member"; }
		if(get_option('photo_team_edit')!="") { $team_edit = get_option('photo_team_edit'); } else { $team_edit = "Edit Member"; }

		register_post_type( 'ourteam',
			array(
				'labels' => array(
					'name' => $team_name,
					'singular_name' => $team_name,
					'add_new_item' => $team_add,
					'edit_item' => $team_edit,
				),
				'public' => true,
				'has_archive' => true,
				'exclude_from_search' => true,
				'rewrite' => array('slug' => $team_slug, 'with_front' => TRUE),
				'supports' => array('title', 'editor', 'author', 'thumbnail', 'page-attributes'),
				'menu_icon' => get_template_directory_uri() . '/includes/posts/img/team.png'			
			)
		);
	}	
	
	/*META*/
	function photo_team_meta() {
		global $post;

		$position = get_post_meta($post->ID, 'position', TRUE);
		$facebook = get_post_meta($post->ID, 'facebook', TRUE);
		$twitter = get_post_meta($post->ID, 'twitter', TRUE);
		$flickr = get_post_meta($post->ID, 'flickr', TRUE);
		$dribbble = get_post_meta($post->ID, 'dribbble', TRUE);

		?>
			<div class="mabuc-form-wrap">
				<table>
					<tr>
						<td  style="width:10%;"><label for="position"><?php _e( 'Position', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="position" id="position" type="text" value="<?php echo $position; ?>" /><br>
							<span class="desc"><?php _e( 'Add position/designation of this member', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="facebook"><?php _e( 'Facebook', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="facebook" id="facebook" type="text" value="<?php echo $facebook; ?>" /><br>
							<span class="desc"><?php _e( 'Add facebook username of this member', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="twitter"><?php _e( 'Twitter', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="twitter" id="twitter" type="text" value="<?php echo $twitter; ?>" /><br>
							<span class="desc"><?php _e( 'Add twitter username of this member', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="flickr"><?php _e( 'Flickr', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="flickr" id="flickr" type="text" value="<?php echo $flickr; ?>" /><br>
							<span class="desc"><?php _e( 'Add flickr profile url of this member', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
					<tr>
						<td><label for="dribbble"><?php _e( 'Dribbble', CODEEX_THEME_NAME ); ?></label></td>
						<td>
							<input name="dribbble" id="dribbble" type="text" value="<?php echo $dribbble; ?>" /><br>
							<span class="desc"><?php _e( 'Add dribbble id of this member', CODEEX_THEME_NAME ); ?></span>
						</td>
					</tr>
				</table>
			</div>	
		<?php
	}
	
	/*CUSTOM COLUMNS*/
	add_filter( 'manage_edit-ourteam_columns', 'photo_edit_ourteam_columns' ) ;
	function photo_edit_ourteam_columns( $columns ) {
		$columns = array(
			'cb' => '<input type="checkbox" />',
			'title' => __( 'Name', CODEEX_THEME_NAME ),
			'thumbnail' => __( 'Thumbnail', CODEEX_THEME_NAME ),	
			'author' => __( 'Author', CODEEX_THEME_NAME ),			
			'date' => __( 'Date', CODEEX_THEME_NAME )
		);
		return $columns;
	}
	
	/*CUSTOM COLUMNS LIST*/
	add_action( 'manage_ourteam_posts_custom_column', 'photo_manage_ourteam_columns', 10, 2 );
	function photo_manage_ourteam_columns( $column, $post_id ) {
		global $post;

		switch( $column ) {
			case 'thumbnail' : 
      			echo the_post_thumbnail( array(35,35) );
      		break;
			
			default :
			break;
		}
	}



	/**********************************************
	SAVE & UPDATE CUSTOM FIELDS
	***********************************************/
	
	add_action( 'add_meta_boxes', 'photo_custom_posts_team' );
	function photo_custom_posts_team(){
		add_meta_box("photo_team_meta", "Team Options", "photo_team_meta", "ourteam", "normal", "low");	
	}	
	
	add_action('save_post', 'photo_custom_posts_save_team');
	function photo_custom_posts_save_team( $post_id ){
		
		if ((defined('DOING_AUTOSAVE') && DOING_AUTOSAVE) || (defined('DOING_AJAX') && DOING_AJAX)) return;
		if ( 'page' == isset($_POST['post_type']) ) { if ( !current_user_can( 'edit_page', $post_id ) ) return;
		} else { if ( !current_user_can( 'edit_post', $post_id ) ) return; }
		
		update_post_meta($post_id, "position", @$_POST["position"]);
		update_post_meta($post_id, "facebook", @$_POST["facebook"]);
		update_post_meta($post_id, "twitter", @$_POST["twitter"]);
		update_post_meta($post_id, "flickr", @$_POST["flickr"]);
		update_post_meta($post_id, "dribbble", @$_POST["dribbble"]);
	}	
?>