/*
    jQuery.kinetic v1.2
    Dave Taylor http://the-taylors.org/jquery.kinetic
    The MIT License (MIT)
    Copyright (c) <2011> <Dave Taylor http://the-taylors.org>
*/
(function($){'use strict';var DEFAULT_SETTINGS={decelerate:true,y:true,x:true,slowdown:0.9,maxvelocity:40,throttleFPS:60,movingClass:{up:'kinetic-moving-up',down:'kinetic-moving-down',left:'kinetic-moving-left',right:'kinetic-moving-right'},deceleratingClass:{up:'kinetic-decelerating-up',down:'kinetic-decelerating-down',left:'kinetic-decelerating-left',right:'kinetic-decelerating-right'}},SETTINGS_KEY='kinetic-settings';if(!window.requestAnimationFrame){window.requestAnimationFrame=(function(){return window.webkitRequestAnimationFrame||window.mozRequestAnimationFrame||window.oRequestAnimationFrame||window.msRequestAnimationFrame||function(callback,element){window.setTimeout(callback,1000/60);};}());}
$.support=$.support||{};$.extend($.support,{touch:"ontouchend"in document});var decelerateVelocity=function(velocity,slowdown){return Math.floor(Math.abs(velocity))===0?0:velocity*slowdown;};var capVelocity=function(velocity,max){var newVelocity=velocity;if(velocity>0){if(velocity>max){newVelocity=max;}}else{if(velocity<(0-max)){newVelocity=(0-max);}}
return newVelocity;};var setMoveClasses=function(settings,classes){this.removeClass(settings.movingClass.up).removeClass(settings.movingClass.down).removeClass(settings.movingClass.left).removeClass(settings.movingClass.right).removeClass(settings.deceleratingClass.up).removeClass(settings.deceleratingClass.down).removeClass(settings.deceleratingClass.left).removeClass(settings.deceleratingClass.right);if(settings.velocity>0){this.addClass(classes.right);}
if(settings.velocity<0){this.addClass(classes.left);}
if(settings.velocityY>0){this.addClass(classes.down);}
if(settings.velocityY<0){this.addClass(classes.up);}};var stop=function($scroller,settings){if(typeof settings.stopped==='function'){settings.stopped.call($scroller,settings);}};var move=function($scroller,settings){var scroller=$scroller[0];if(settings.x&&scroller.scrollWidth>0){scroller.scrollLeft=settings.scrollLeft=scroller.scrollLeft+settings.velocity;if(Math.abs(settings.velocity)>0){settings.velocity=settings.decelerate?decelerateVelocity(settings.velocity,settings.slowdown):settings.velocity;}}
if(settings.y&&scroller.scrollHeight>0){scroller.scrollTop=settings.scrollTop=scroller.scrollTop+settings.velocityY;if(Math.abs(settings.velocityY)>0){settings.velocityY=settings.decelerate?decelerateVelocity(settings.velocityY,settings.slowdown):settings.velocityY;}}
setMoveClasses.call($scroller,settings,settings.deceleratingClass);if(typeof settings.moved==='function'){settings.moved.call($scroller,settings);}
if(Math.abs(settings.velocity)>0||Math.abs(settings.velocityY)>0){window.requestAnimationFrame(function(){move($scroller,settings);});}else{stop($scroller,settings);}};var callOption=function(method,options){var methodFn=$.kinetic.callMethods[method],args=Array.prototype.slice.call(arguments);if(methodFn){this.each(function(){var opts=args.slice(1),settings=$(this).data(SETTINGS_KEY);opts.unshift(settings);methodFn.apply(this,opts);});}};var initElements=function(options){this.addClass('kinetic-active').attr('tabindex','0').each(function(){var settings=$.extend({},DEFAULT_SETTINGS,options);var $this=$(this),xpos,prevXPos=false,ypos,prevYPos=false,mouseDown=false,scrollLeft,scrollTop,throttleTimeout=1000/settings.throttleFPS,lastMove,elementFocused;settings.velocity=0;settings.velocityY=0;$this.bind("selectstart",function(){return false;});var resetMouse=function(){xpos=false;ypos=false;mouseDown=false;};$(document).mouseup(resetMouse).click(resetMouse);var calculateVelocities=function(){settings.velocity=capVelocity(prevXPos-xpos,settings.maxvelocity);settings.velocityY=capVelocity(prevYPos-ypos,settings.maxvelocity);};var start=function(clientX,clientY){mouseDown=true;settings.velocity=prevXPos=0;settings.velocityY=prevYPos=0;xpos=clientX;ypos=clientY;};var end=function(){if(xpos!==undefined&&prevXPos!==undefined&&settings.decelerate===false){settings.decelerate=true;calculateVelocities();xpos=prevXPos=mouseDown=false;move($this,settings);}};var inputmove=function(clientX,clientY){if(!lastMove||new Date()>new Date(lastMove.getTime()+throttleTimeout)){lastMove=new Date();if(mouseDown&&(xpos||ypos)){if(elementFocused){$(elementFocused).blur();elementFocused=null;$this.focus();}
settings.decelerate=false;settings.velocity=settings.velocityY=0;$this[0].scrollLeft=settings.scrollLeft=settings.x?$this[0].scrollLeft-(clientX-xpos):$this[0].scrollLeft;$this[0].scrollTop=settings.scrollTop=settings.y?$this[0].scrollTop-(clientY-ypos):$this[0].scrollTop;prevXPos=xpos;prevYPos=ypos;xpos=clientX;ypos=clientY;calculateVelocities();setMoveClasses.call($this,settings,settings.movingClass);if(typeof settings.moved==='function'){settings.moved.call($this,settings);}}}};if($.support.touch){this.addEventListener('touchstart',function(e){start(e.touches[0].clientX,e.touches[0].clientY);},false);this.addEventListener('touchend',function(e){if(e.preventDefault){e.preventDefault();}
end();},false);this.addEventListener('touchmove',function(e){if(e.preventDefault){e.preventDefault();}
inputmove(e.touches[0].clientX,e.touches[0].clientY);},false);}else{$this.mousedown(function(e){start(e.clientX,e.clientY);elementFocused=e.target;e.preventDefault();}).mouseup(function(){end();elementFocused=null;}).mouseleave(function(){end();}).mousemove(function(e){inputmove(e.clientX,e.clientY);e.preventDefault();}).css("cursor","move");}
$this.click(function(e){if(Math.abs(settings.velocity)>0){e.preventDefault();return false;}});$this.data(SETTINGS_KEY,settings);});};$.kinetic={settingsKey:SETTINGS_KEY,callMethods:{start:function(settings,options){var $this=$(this);settings=$.extend(settings,options);if(settings){settings.decelerate=false;move($this,settings);}},end:function(settings,options){var $this=$(this);if(settings){settings.decelerate=true;}}}};$.fn.kinetic=function(options){if(typeof options==='string'){callOption.apply(this,arguments);}else{initElements.call(this,options);}
return this;};}(window.jQuery||window.Zepto));